--19820
SELECT CustomerID, PersonID, StoreID, TerritoryID
FROM Sales.Customer;

--31,465
SELECT SalesOrderID, CustomerID, OrderDate, TotalDue
FROM Sales.SalesOrderHeader;

--31,465
-- INNER JOIN is the same as JOIN
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue 
FROM Sales.Customer AS C 
INNER JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID;

--32,166
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue 
FROM Sales.Customer AS C 
LEFT OUTER JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID;

--701
--LEFT OUTER JOIN is the same as LEFT JOIN
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue 
FROM Sales.Customer AS C 
LEFT OUTER JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID
WHERE SOH.SalesOrderID IS NULL;

--121,317
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue, SOD.ProductID, SOD.OrderQty 
FROM Sales.Customer AS C 
LEFT OUTER JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID
INNER JOIN Sales.SalesOrderDetail AS SOD 
	ON SOH.SalesOrderID = SOD.SalesOrderID;

--0
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue, SOD.ProductID, SOD.OrderQty 
FROM Sales.Customer AS C 
LEFT OUTER JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID
INNER JOIN Sales.SalesOrderDetail AS SOD 
	ON SOH.SalesOrderID = SOD.SalesOrderID
WHERE SOH.SalesOrderID IS NULL;

--122,018 (Previously, 121,317)
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue, SOD.ProductID, SOD.OrderQty 
FROM Sales.Customer AS C 
LEFT JOIN Sales.SalesOrderHeader AS SOH
	ON C.CustomerID = SOH.CustomerID
LEFT JOIN Sales.SalesOrderDetail AS SOD 
	ON SOH.SalesOrderID = SOD.SalesOrderID;

--RIGHT JOIN
SELECT C.CustomerID, C.PersonID, C.StoreID, C.TerritoryID, 
	SOH.SalesOrderID, FORMAT(SOH.OrderDate, 'yyyy-MM-dd') AS OrderDate, 
	SOH.TotalDue, SOD.ProductID, SOD.OrderQty 
FROM Sales.SalesOrderHeader AS SOH
RIGHT JOIN Sales.Customer AS C 
 ON C.CustomerID = SOH.CustomerID
LEFT JOIN Sales.SalesOrderDetail AS SOD 
	ON SOH.SalesOrderID = SOD.SalesOrderID;